<tbody is="draggable" tag="tbody" handle=".handle" @start="dragging = true" @end="dragging = false" @update="onItemSortUpdate">
    <tr v-for="(row, index) in items" :index="index">
        <?php echo $__env->yieldPushContent('name_td_start'); ?>

        <td class="border-r-0 border-b-0 p-0"
            :class="[{'has-error': form.errors.has('items.' + index + '.name') }]"
            colspan="7">
            <table class="w-full border-b pb-3">
                <colgroup>
                    <col class="small-col" style="width: 24px;">
                    <col class="small-col" style="width: 20%;">
                    <col class="small-col description-col" style="width: 30%;">
                    <col class="small-col" style="width: 12%;">
                    <col class="small-col" style="width: 15%;">
                    <col class="small-col amount-col" style="width: 20%;">
                    <col class="small-col" style="width: 24px;">
                </colgroup>

                <tbody>
                    <tr>
                        <?php echo $__env->yieldPushContent('move_td_start'); ?>

                        <td class="align-top" style="width:24px; height:100px; color: #8898aa;">
                            <div class="handle mt-2 hidden lg:block cursor-move">
                                <span class="w-6 material-icons mt-0.5">list</span>
                            </div>
                        </td>

                        <?php echo $__env->yieldPushContent('move_td_end'); ?>

                        <?php echo $__env->yieldPushContent('items_td_start'); ?>

                        <?php if(! $hideItems || (! $hideItemName && ! $hideItemDescription)): ?>
                            <?php echo $__env->yieldPushContent('name_td_start'); ?>

                            <td class="px-3 py-3 ltr:pl-2 rtl:pr-2 ltr:text-left rtl:text-right align-top border-b-0 name">
                                <?php if(! $hideItemName): ?>
                                    <span class="flex items-center text-sm" tabindex="0" v-if="row.item_id">
                                        <div v-html="row.name"></div>
                                    </span>

                                    <div v-else>
                                        <?php echo $__env->yieldPushContent('name_input_start'); ?>

                                        <input
                                            type="text"
                                            :ref="'items-' + index + '-name'"
                                            class="w-full text-sm px-3 py-2.5 rounded-lg border border-light-gray text-black placeholder-light-gray bg-white disabled:bg-gray-200 focus:outline-none focus:ring-transparent focus:border-purple mt-0"
                                            :name="'items.' + index + '.name'"
                                            autocomplete="off"
                                            required="required"
                                            data-item="name"
                                            v-model="row.name"
                                            @input="onBindingItemField(index, 'name')"
                                            @change="form.errors.clear('items.' + index + '.name')"
                                        />

                                        <div class="text-red text-sm mt-1 mb-3 block"
                                            v-if="form.errors.has('items.' + index + '.name')"
                                            v-html="form.errors.get('items.' + index + '.name')"
                                        ></div>

                                        <?php echo $__env->yieldPushContent('name_input_end'); ?>
                                    </div>
                                <?php endif; ?>
                            </td>

                            <?php echo $__env->yieldPushContent('name_td_end'); ?>

                            <?php echo $__env->yieldPushContent('description_td_start'); ?>

                            <td class="px-3 py-3 border-b-0 align-top description">
                                <?php if(! $hideItemDescription): ?>
                                    <textarea
                                        class="w-full text-sm px-3 py-2.5 rounded-lg border border-light-gray text-black placeholder-light-gray bg-white disabled:bg-gray-200 focus:outline-none focus:ring-transparent focus:border-purple"
                                        style="height:42px; min-height:42px;"
                                        :ref="'items-' + index + '-description'"
                                        placeholder="<?php echo e(trans('items.enter_item_description')); ?>"
                                        :name="'items.' + index + '.description'"
                                        v-model="row.description"
                                        data-item="description"
                                        resize="none"
                                        @input="onBindingItemField(index, 'description')"
                                    ></textarea>
                                <?php endif; ?>
                            </td>

                            <?php echo $__env->yieldPushContent('description_td_end'); ?>
                        <?php endif; ?>

                        <?php echo $__env->yieldPushContent('items_td_end'); ?>

                        <?php echo $__env->yieldPushContent('quantity_td_start'); ?>

                        <td class="px-3 py-3 border-b-0 align-top quantity">
                            <?php if(! $hideItemQuantity): ?>
                                <div>
                                    <?php echo $__env->yieldPushContent('quantity_input_start'); ?>

                                    <input
                                        type="number"
                                        min="0"
                                        :ref="'items-' + index + '-quantity'"
                                        class="w-full text-sm px-3 py-2.5 mt-0 text-right rounded-lg border border-light-gray text-black placeholder-light-gray bg-white disabled:bg-gray-200 focus:outline-none focus:ring-transparent focus:border-purple input-number-disabled"
                                        :name="'items.' + index + '.quantity'"
                                        autocomplete="off"
                                        required="required"
                                        data-item="quantity"
                                        v-model="row.quantity"
                                        @input="onCalculateTotal"
                                        @change="form.errors.clear('items.' + index + '.quantity')"
                                    />

                                    <div class="text-red text-sm mt-1 mb-3 block"
                                        v-if="form.errors.has('items.' + index + '.quantity')"
                                        v-html="form.errors.get('items.' + index + '.quantity')">
                                    </div>

                                    <?php echo $__env->yieldPushContent('quantity_input_end'); ?>
                                </div>
                            <?php endif; ?>
                        </td>

                        <?php echo $__env->yieldPushContent('quantity_td_end'); ?>

                        <?php echo $__env->yieldPushContent('price_td_start'); ?>

                        <td class="px-3 py-3 pr-1 border-b-0 align-top price">
                            <div>
                                <?php echo $__env->yieldPushContent('price_input_start'); ?>

                                <?php if (isset($component)) { $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $attributes; } ?>
<?php $component = App\View\Components\Form\Input\Money::resolve(['name' => 'price','value' => '0','formGroupClass' => 'text-right'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input.money'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\Input\Money::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['row-input' => true,'data-item' => 'price','v-model' => 'row.price','v-error' => 'form.errors.get(\'items.\' + index + \'.price\')','v-error-message' => 'form.errors.get(\'items.\' + index + \'.price\')','change' => 'row.price = $event; form.errors.clear(\'items.\' + index + \'.price\'); onCalculateTotal','currency' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($currency),'dynamicCurrency' => 'currency','money-class' => 'text-right mt-0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $attributes = $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $component = $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>

                                <?php echo $__env->yieldPushContent('price_input_end'); ?>
                            </div>
                        </td>

                        <?php echo $__env->yieldPushContent('price_td_end'); ?>

                        <?php echo $__env->yieldPushContent('total_td_start'); ?>

                        <td class="px-3 py-3 text-right border-b-0 align-top total">
                            <?php if(! $hideItemAmount): ?>
                                <div>
                                    <?php if (isset($component)) { $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $attributes; } ?>
<?php $component = App\View\Components\Form\Input\Money::resolve(['name' => 'total','value' => '0','disabled' => true,'formGroupClass' => 'ltr:text-right rtl:text-left disabled-money'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input.money'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\Input\Money::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['row-input' => true,'data-item' => 'total','v-model' => 'row.total','currency' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($currency),'dynamicCurrency' => 'currency','money-class' => 'ltr:text-right rtl:text-left mt-0 disabled-money px-0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $attributes = $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $component = $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </td>

                        <?php echo $__env->yieldPushContent('total_td_end'); ?>

                        <?php echo $__env->yieldPushContent('delete_td_start'); ?>

                        <td class="text-right align-top group">
                            <button type="button" @click="onDeleteItem(index)" class="w-6 h-7 flex items-center rounded-lg p-0 group-hover:bg-gray-100 mt-4">
                                <span class="w-full material-icons-outlined text-lg text-gray-300 group-hover:text-gray-500">delete</span>
                            </button>
                        </td>

                        <?php echo $__env->yieldPushContent('delete_td_end'); ?>
                    </tr>

                    <tr>
                        <td colspan="3">
                            <?php echo $__env->yieldPushContent('item_custom_fields'); ?>
                        </td>

                        <td colspan="4" class="px-0 pb-3">
                            <div class="relative">
                                <div class="absolute -top-6 ltr:left-3 rtl:right-3 flex items-center">
                                    <?php if(! $hideDiscount && in_array(setting('localisation.discount_location'), ['item', 'both'])): ?>
                                        <div class="text-left border-0 p-0 mr-16" v-if="!row.add_discount">
                                            <?php if (isset($component)) { $__componentOriginale67687e3e4e61f963b25a6bcf3983629 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale67687e3e4e61f963b25a6bcf3983629 = $attributes; } ?>
<?php $component = App\View\Components\Button::resolve(['type' => 'button','class' => 'text-xs text-purple','override' => 'class'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['@click' => 'onAddLineDiscount(index)']); ?>
                                                <?php if (isset($component)) { $__componentOriginal0ab9649d9e51ab46b805f282c1760eb7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7 = $attributes; } ?>
<?php $component = App\View\Components\Button\Hover::resolve(['color' => 'to-purple'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button.hover'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button\Hover::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                                    <?php echo e(trans('general.title.add', ['type' => trans('invoices.discount')])); ?>

                                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7)): ?>
<?php $attributes = $__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7; ?>
<?php unset($__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0ab9649d9e51ab46b805f282c1760eb7)): ?>
<?php $component = $__componentOriginal0ab9649d9e51ab46b805f282c1760eb7; ?>
<?php unset($__componentOriginal0ab9649d9e51ab46b805f282c1760eb7); ?>
<?php endif; ?>
                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $attributes = $__attributesOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $component = $__componentOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__componentOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
                                        </div>
                                    <?php endif; ?>

                                    <div class="text-right border-0 p-0 pr-4">
                                        <?php if (isset($component)) { $__componentOriginale67687e3e4e61f963b25a6bcf3983629 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale67687e3e4e61f963b25a6bcf3983629 = $attributes; } ?>
<?php $component = App\View\Components\Button::resolve(['type' => 'button','class' => 'text-xs text-purple','override' => 'class'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['@click' => 'onAddTax(index)']); ?>
                                            <?php if (isset($component)) { $__componentOriginal0ab9649d9e51ab46b805f282c1760eb7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7 = $attributes; } ?>
<?php $component = App\View\Components\Button\Hover::resolve(['color' => 'to-purple'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button.hover'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Button\Hover::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                                <?php echo e(trans('general.title.add', ['type' => trans_choice('general.taxes', 1)])); ?>

                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7)): ?>
<?php $attributes = $__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7; ?>
<?php unset($__attributesOriginal0ab9649d9e51ab46b805f282c1760eb7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0ab9649d9e51ab46b805f282c1760eb7)): ?>
<?php $component = $__componentOriginal0ab9649d9e51ab46b805f282c1760eb7; ?>
<?php unset($__componentOriginal0ab9649d9e51ab46b805f282c1760eb7); ?>
<?php endif; ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $attributes = $__attributesOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__attributesOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale67687e3e4e61f963b25a6bcf3983629)): ?>
<?php $component = $__componentOriginale67687e3e4e61f963b25a6bcf3983629; ?>
<?php unset($__componentOriginale67687e3e4e61f963b25a6bcf3983629); ?>
<?php endif; ?>
                                    </div>
                                </div>
                            </div>

                            <div v-if="row.add_discount" class="flex items-center justify-between pb-3 ml-2">
                                <?php echo $__env->yieldPushContent('discount_input_start'); ?>

                                <div class="mb-0" style="display: inline-block; position: relative;">
                                    <div class="flex items-center">
                                        <div class="w-16 flex items-center bg-gray-200 p-1 ltr:mr-2 rtl:ml-2 rounded-lg">
                                            <button type="button"
                                                class="w-7 flex justify-center px-2"
                                                :class="[{'btn-outline-primary' : row.discount_type !== 'percentage'}, {'bg-white rounded-lg' : row.discount_type === 'percentage'}]"
                                                @click="onChangeLineDiscountType(index, 'percentage')"
                                            >
                                                <span class="material-icons text-lg">percent</span>
                                            </button>

                                            <button type="button"
                                                class="w-7 px-2"
                                                :class="[{'btn-outline-primary' : row.discount_type !== 'fixed'}, {'bg-white rounded-lg' : row.discount_type === 'fixed'}]"
                                                @click="onChangeLineDiscountType(index, 'fixed')"
                                            >
                                                <span class="text-base"><?php echo e(($currency) ? $currency->symbol : '$'); ?></span>
                                            </button>
                                        </div>

                                        <input type="number"
                                            min="0"
                                            placeholder="Discount"
                                            class="w-full text-sm px-3 py-2.5 mt-0 text-center rounded-lg border border-light-gray text-black placeholder-light-gray bg-white disabled:bg-gray-200 focus:outline-none focus:ring-transparent focus:border-purple"
                                            :name="'items.' + index + '.discount'"
                                            autocomplete="off"
                                            required="required"
                                            data-item="discount"
                                            v-model="row.discount"
                                            @input="onCalculateTotal"
                                            @change="form.errors.clear('items.' + index + '.discount')"
                                        />

                                        <div class="text-red text-sm mt-1 mb-3 block"
                                            v-if="form.errors.has('items.' + index + '.discount')"
                                            v-html="form.errors.get('items.' + index + '.discount')">
                                        </div>
                                    </div>
                                </div>

                                <?php echo $__env->yieldPushContent('discount_input_end'); ?>

                                <div class="flex items-center lg:absolute ltr:right-0 rtl:left-0">
                                    <div class="text-right">
                                        <?php if (isset($component)) { $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $attributes; } ?>
<?php $component = App\View\Components\Form\Input\Money::resolve(['name' => 'discount_amount','value' => '0','disabled' => true,'formGroupClass' => 'ltr:text-right rtl:text-left disabled-money'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input.money'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\Input\Money::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['row-input' => true,'data-item' => 'discount_amount','v-model' => 'row.discount_amount','currency' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($currency),'dynamicCurrency' => 'currency','money-class' => 'ltr:text-right rtl:text-left disabled-money px-0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $attributes = $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $component = $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
                                    </div>

                                    <div class="ltr:pl-2 rtl:pr-2 group">
                                        <button type="button" @click="onDeleteDiscount(index)" class="w-6 h-7 flex items-center rounded-lg p-0 group-hover:bg-gray-100">
                                            <span class="w-full material-icons-outlined text-lg text-gray-300 group-hover:text-gray-500">delete</span>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div class="flex items-center justify-between h-10 ml-3 my-3" v-for="(row_tax, row_tax_index) in row.tax_ids"
                                :index="row_tax_index"
                            >
                                <span class="absolute text-sm ltr:right-1/2 rtl:left-1/2 ltr:-ml-7 rtl:-mr-7"><?php echo e(trans_choice('general.taxes', 1)); ?></span>

                                <div class="lg:w-1/4 lg:absolute">
                                    <?php echo $__env->yieldPushContent('taxes_input_start'); ?>

                                    <akaunting-select
                                        class="mb-0 select-tax"
                                        :form-classes="[{'has-error': form.errors.has('items.' + index + '.taxes') }]"
                                        :icon="''"
                                        :title="''"
                                        :placeholder="'<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.taxes', 1)])); ?>'"
                                        :name="'items.' + index + '.taxes.' + row_tax_index"
                                        :options="<?php echo e(json_encode($taxes)); ?>"
                                        :dynamic-options="dynamic_taxes"
                                        :disabled-options="form.items[index].tax_ids"
                                        :value="row_tax.id"
                                        :add-new="<?php echo e(json_encode([
                                            'status' => true,
                                            'text' => trans('general.title.new', ['type' => trans_choice('general.taxes', 1)]),
                                            'path' => route('modals.taxes.create'),
                                            'type' => 'modal',
                                            'field' => [
                                                'key' => 'id',
                                                'value' => 'title'
                                            ],
                                            'new_text' => trans('modules.new'),
                                            'buttons' => [
                                                'cancel' => [
                                                    'text' => trans('general.cancel'),
                                                    'class' => 'btn-outline-secondary'
                                                ],
                                                'confirm' => [
                                                    'text' => trans('general.save'),
                                                    'class' => 'disabled:bg-green-100'
                                                ]
                                            ]
                                        ])); ?>"
                                        @interface="row_tax.id = $event"
                                        @change="onCalculateTotal()"
                                        @new="dynamic_taxes.push($event)"
                                        :form-error="form.errors.get('items.' + index + '.taxes')"
                                        :no-data-text="'<?php echo e(trans('general.no_data')); ?>'"
                                        :no-matching-data-text="'<?php echo e(trans('general.no_matching_data')); ?>'"
                                    >
                                        <template #option="{option}">
                                            <span class="tax-group flex items-center">
                                                <span class="float-left">
                                                    {{ option.value }}
                                                </span>

                                                <span 
                                                    class="inline-flex items-center h-5 rounded-md bg-gray-50 font-medium text-gray-600 ring-1 ring-inset ring-gray-500/10"
                                                    style="width: auto; font-size: 0.56rem;"
                                                >
                                                    <template v-if="option.option.type == 'normal'">
                                                        <?php echo e(trans('taxes.normal')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'fixed'">
                                                        <?php echo e(trans('taxes.fixed')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'inclusive'">
                                                        <?php echo e(trans('taxes.inclusive')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'withholding'">
                                                        <?php echo e(trans('taxes.withholding')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'compound'">
                                                        <?php echo e(trans('taxes.compound')); ?>

                                                    </template>
                                                </span>
                                            </span>
                                        </template>
                                    </akaunting-select>

                                    <?php echo $__env->yieldPushContent('taxes_input_end'); ?>
                                </div>

                                <div class="flex items-center lg:absolute ltr:right-0 rtl:left-0">
                                    <div class="text-right">
                                        <?php if (isset($component)) { $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220 = $attributes; } ?>
<?php $component = App\View\Components\Form\Input\Money::resolve(['name' => 'tax','value' => '0','disabled' => true,'formGroupClass' => 'text-right disabled-money'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('form.input.money'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Form\Input\Money::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['row-input' => true,'data-item' => 'total','v-model' => 'row_tax.price','currency' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($currency),'dynamicCurrency' => 'currency','money-class' => 'text-right disabled-money px-0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $attributes = $__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__attributesOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220)): ?>
<?php $component = $__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220; ?>
<?php unset($__componentOriginal6dd1ae3e63ecbf0a9c7e437117302220); ?>
<?php endif; ?>
                                    </div>

                                    <div class="ltr:pl-2 rtl:pr-2 group">
                                        <button type="button" @click="onDeleteTax(index, row_tax_index)" class="w-6 h-7 flex items-center rounded-lg p-0 group-hover:bg-gray-100">
                                            <span class="w-full material-icons-outlined text-lg text-gray-300 group-hover:text-gray-500">delete</span>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <div v-if="row.add_tax" class="flex items-center justify-between h-10 ml-3 my-3" :class="{'pt-2' : row.add_discount}">
                                <span class="absolute text-sm ltr:right-1/2 rtl:left-1/2 ltr:-ml-7 rtl:-mr-7"><?php echo e(trans_choice('general.taxes', 1)); ?></span>

                                <div class="lg:w-1/4 lg:absolute">
                                    <?php echo $__env->yieldPushContent('taxes_input_start'); ?>

                                    <akaunting-select
                                        class="mb-0 select-tax"
                                        style="margin-left: 1px; margin-right: -2px;"
                                        :form-classes="[{'has-error': form.errors.has('items.' + index + '.taxes') }]"
                                        :icon="''"
                                        :title="''"
                                        :placeholder="'<?php echo e(trans('general.form.select.field', ['field' => trans_choice('general.taxes', 1)])); ?>'"
                                        :name="'items.' + index + '.taxes.999'"
                                        :options="<?php echo e(json_encode($taxes)); ?>"
                                        :dynamic-options="dynamic_taxes"
                                        :disabled-options="form.items[index].tax_ids"
                                        :value="tax_id"
                                        :add-new="<?php echo e(json_encode([
                                            'status' => true,
                                            'text' => trans('general.title.new', ['type' => trans_choice('general.taxes', 1)]),
                                            'path' => route('modals.taxes.create'),
                                            'type' => 'modal',
                                            'field' => [
                                                'key' => 'id',
                                                'value' => 'title'
                                            ],
                                            'new_text' => trans('modules.new'),
                                            'buttons' => [
                                                'cancel' => [
                                                    'text' => trans('general.cancel'),
                                                    'class' => 'btn-outline-secondary'
                                                ],
                                                'confirm' => [
                                                    'text' => trans('general.save'),
                                                    'class' => 'disabled:bg-green-100'
                                                ]
                                            ]
                                        ])); ?>"
                                        @interface="tax_id = $event"
                                        @visible-change="onSelectedTax(index)"
                                        @new="dynamic_taxes.push($event)"
                                        :form-error="form.errors.get('items.' + index + '.taxes')"
                                        :no-data-text="'<?php echo e(trans('general.no_data')); ?>'"
                                        :no-matching-data-text="'<?php echo e(trans('general.no_matching_data')); ?>'"
                                    >
                                        <template #option="{option}">
                                            <span class="tax-group flex items-center">
                                                <span class="float-left">
                                                    {{ option.value }}
                                                </span>

                                                <span 
                                                    class="inline-flex items-center h-5 rounded-md bg-gray-50 font-medium text-gray-600 ring-1 ring-inset ring-gray-500/10"
                                                    style="width: auto; font-size: 0.56rem;"
                                                >
                                                    <template v-if="option.option.type == 'normal'">
                                                        <?php echo e(trans('taxes.normal')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'fixed'">
                                                        <?php echo e(trans('taxes.fixed')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'inclusive'">
                                                        <?php echo e(trans('taxes.inclusive')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'withholding'">
                                                        <?php echo e(trans('taxes.withholding')); ?>

                                                    </template>
                                                    <template v-if="option.option.type == 'compound'">
                                                        <?php echo e(trans('taxes.compound')); ?>

                                                    </template>
                                                </span>
                                            </span>
                                        </template>
                                    </akaunting-select>

                                    <?php echo $__env->yieldPushContent('taxes_input_end'); ?>
                                </div>

                                <div class="flex items-center lg:absolute ltr:right-0 rtl:left-0">
                                    <div class="text-right">
                                        <div class="required disabled text-right input-price disabled-money">
                                            <input type="tel" class="v-money form-control ltr:text-right rtl:text-left" name="discount_amount" disabled="disabled" value="__">
                                        </div>
                                    </div>

                                    <div class="ltr:pl-2 rtl:pr-2 group">
                                        <button type="button" @click="onDeleteTax(index, 999)" class="w-6 h-7 flex items-center rounded-lg p-0 group-hover:bg-gray-100">
                                            <span class="w-full material-icons-outlined text-lg text-gray-300 group-hover:text-gray-500">delete</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </td>

        <?php echo $__env->yieldPushContent('name_td_end'); ?>
    </tr>
</tbody>
<?php /**PATH /home1/pmnvir/public_html/acc/resources/views/components/documents/form/line-item.blade.php ENDPATH**/ ?>